/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.spi.ErrorHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerSupportTest
extends ContextTestSupport {
    @Test
    public void testOnePolicyChildFirst() {
        ArrayList<Class> exceptions = new ArrayList<Class>();
        exceptions.add(ChildException.class);
        exceptions.add(ParentException.class);
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(exceptions));
        Assertions.assertEquals((Object)ChildException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        Assertions.assertEquals((Object)ParentException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 1));
    }

    @Test
    public void testOnePolicyChildLast() {
        ArrayList<Class> exceptions = new ArrayList<Class>();
        exceptions.add(ParentException.class);
        exceptions.add(ChildException.class);
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(exceptions));
        Assertions.assertEquals((Object)ChildException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 1));
        Assertions.assertEquals((Object)ParentException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    @Test
    public void testTwoPolicyChildFirst() {
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(ChildException.class));
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(ParentException.class));
        Assertions.assertEquals((Object)ChildException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        Assertions.assertEquals((Object)ParentException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    @Test
    public void testTwoPolicyChildLast() {
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(ParentException.class));
        ErrorHandlerSupportTest.addExceptionPolicy(support, this.context.getRoute("foo"), new OnExceptionDefinition(ChildException.class));
        Assertions.assertEquals((Object)ChildException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        Assertions.assertEquals((Object)ParentException.class.getName(), (Object)ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    private static void addExceptionPolicy(ErrorHandlerSupport handlerSupport, Route route, OnExceptionDefinition exceptionType) {
        new DefaultErrorHandlerReifier(route, null).addExceptionPolicy(handlerSupport, exceptionType);
    }

    private static String getExceptionPolicyFor(ErrorHandlerSupport support, Throwable childException, int index) {
        return (String)support.getExceptionPolicy(null, childException).getExceptions().get(index);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").to("mock:foo")).routeId("foo");
            }
        };
    }

    private static class ChildException
    extends ParentException {
        private static final long serialVersionUID = 1L;

        private ChildException() {
        }
    }

    private static class ParentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ParentException() {
        }
    }

    private static class ShuntErrorHandlerSupport
    extends ErrorHandlerSupport {
        private ShuntErrorHandlerSupport() {
        }

        public boolean supportTransacted() {
            return false;
        }

        public Processor getOutput() {
            return null;
        }

        public ErrorHandler clone(Processor output) {
            return null;
        }

        public void process(Exchange exchange) {
        }
    }
}

