/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerDynamicContinueTest
extends ContextTestSupport {
    @Test
    public void testContinued() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "exception", (Object)"iae");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotContinued() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        CamelExecutionException exception = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "exception", (Object)"uoe"));
        Assertions.assertEquals(UnsupportedOperationException.class, exception.getCause().getClass());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).maximumRedeliveries(1).continued(exchange -> {
                    Exception e = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                    return e instanceof IllegalArgumentException;
                });
                ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).choice().when((Predicate)this.simple("${header.exception} == 'iae'")).throwException((Exception)new IllegalArgumentException("Forced"))).otherwise().throwException((Exception)new UnsupportedOperationException())).end().to("mock:result");
            }
        };
    }
}

