/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PollTest
extends ContextTestSupport {
    protected MockEndpoint mock;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mock = this.getMockEndpoint("mock:mock");
    }

    @Test
    public void testPoll() throws InterruptedException {
        this.template.sendBody("seda:foo1", (Object)"blah");
        this.mock.expectedBodiesReceived(new Object[]{"blah"});
        this.template.sendBody("direct:enricher-test-1", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    @Test
    public void testPollWithTimeout() throws InterruptedException {
        this.mock.expectedBodiesReceived(new Object[]{"blah"});
        this.template.sendBody("direct:enricher-test-2", (Object)"test");
        this.mock.assertIsNotSatisfied();
        this.mock.reset();
        this.template.sendBody("seda:foo2", (Object)"blah");
        this.template.sendBody("direct:enricher-test-2", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    @Test
    public void testPollNoTimeout() throws InterruptedException {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PollTest.this.template.sendBody("seda:foo3", (Object)"blah");
            }
        });
        StopWatch watch = new StopWatch();
        this.mock.expectedBodiesReceived(new Object[]{"blah"});
        t.start();
        this.template.sendBody("direct:enricher-test-3", (Object)"test");
        this.mock.assertIsSatisfied();
        long delta = watch.taken();
        Assertions.assertTrue((delta > 150L ? 1 : 0) != 0, (String)("Should take approx 0.25 sec: was " + delta));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:enricher-test-1").poll("seda:foo1")).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-2").poll("seda:foo2", 1000L)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-3").poll("seda:foo3", -1L)).to("mock:mock");
            }
        };
    }
}

