/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnricherRefTest
extends ContextTestSupport {
    private final SedaEndpoint cool = new SedaEndpoint();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("cool", (Object)this.cool);
        jndi.bind("agg", (Object)new UseLatestAggregationStrategy());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.cool.setCamelContext(context);
        return context;
    }

    @Test
    public void testPollEnrichRef() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Bye World");
        this.cool.getQueue().add(exchange);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        Assertions.assertEquals((int)0, (int)this.cool.getQueue().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                PollEnricherRefTest.this.cool.setEndpointUriIfNotSpecified("cool");
                ((PollEnrichDefinition)this.from("direct:start").pollEnrich().simple("ref:cool")).timeout(2000L).aggregationStrategy("agg");
            }
        };
    }
}

