/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnricherNoResourceTest
extends ContextTestSupport {
    @Test
    public void testNoResourceA() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testResourceA() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Bye World");
        Thread.sleep(250L);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testResourceB() throws Exception {
        this.template.sendBody("seda:bar", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").pollEnrich("seda:foo", 1000L)).process(e -> Assertions.assertEquals((Object)"seda://foo", (Object)e.getProperty("CamelToEndpoint")))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").pollEnrich("seda:bar")).process(e -> Assertions.assertEquals((Object)"seda://bar", (Object)e.getProperty("CamelToEndpoint")))).to("mock:result");
            }
        };
    }
}

