/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnricherFileTest
extends ContextTestSupport {
    @Test
    public void testPollEnrichFile() throws Exception {
        this.getMockEndpoint("mock:2").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:2").message(0).body()).isNull();
        this.assertMockEndpointsSatisfied();
        long ex1 = (Long)((Exchange)this.getMockEndpoint("mock:1").getExchanges().get(0)).getProperty("CamelReceivedTimestamp", Long.TYPE);
        long ex2 = (Long)((Exchange)this.getMockEndpoint("mock:2").getExchanges().get(0)).getProperty("CamelReceivedTimestamp", Long.TYPE);
        long delta = ex2 - ex1;
        Assertions.assertTrue((delta > 800L ? 1 : 0) != 0, (String)("Should delay for at least 1 second, was " + delta + " millis"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("timer:hello?repeatCount=1&delay=10").to(new String[]{"log:1", "mock:1"})).pollEnrich("file:target/temp?noop=true&fileName=doesnotexist.csv", 1000L)).to(new String[]{"log:2", "mock:2"});
            }
        };
    }
}

