/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnricherAggregateOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testEnrichTrueOk() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEnrichTrueKaboom() throws Exception {
        this.template.send("seda:foo", new Processor(){

            public void process(Exchange exchange) {
                exchange.setException((Throwable)new IllegalArgumentException("I cannot do this"));
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"I cannot do this"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEnrichFalseOk() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start2", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEnrichFalseKaboom() throws Exception {
        this.template.send("seda:foo", new Processor(){

            public void process(Exchange exchange) {
                exchange.setException((Throwable)new IllegalArgumentException("I cannot do this"));
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start2", (Object)"Kaboom");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            PollEnricherAggregateOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"I cannot do this", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").pollEnrich("seda:foo", 5000L, (AggregationStrategy)new MyAggregationStrategy(), true)).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").pollEnrich("seda:foo", 5000L, (AggregationStrategy)new MyAggregationStrategy(), false)).to("mock:result");
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange.getException() != null) {
                oldExchange.getIn().setBody((Object)newExchange.getException().getMessage());
                return oldExchange;
            }
            oldExchange.getIn().setBody(newExchange.getIn().getBody());
            return oldExchange;
        }
    }
}

