/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class PollEnrichFileDefaultAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void testPollEnrichDefaultAggregationStrategyBody() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists(this.testFile("enrich/.done/AAA.fin"));
        mock.expectedFileExists(this.testFile("enrichdata/.done/AAA.dat"));
        this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.context.getRouteController().startAllRoutes();
        this.log.info("Sleeping for 0.25 sec before writing enrichdata file");
        Thread.sleep(250L);
        this.template.sendBodyAndHeader(this.fileUri("enrichdata"), (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
        this.log.info("... write done");
        this.assertMockEndpointsSatisfied();
        PollEnrichFileDefaultAggregationStrategyTest.assertFileNotExists(this.testFile("enrichdata/AAA.dat.camelLock"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(PollEnrichFileDefaultAggregationStrategyTest.this.fileUri("enrich?initialDelay=0&delay=10&move=.done")).autoStartup(false).to("mock:start")).pollEnrich(PollEnrichFileDefaultAggregationStrategyTest.this.fileUri("enrichdata?initialDelay=0&delay=10&readLock=markerFile&move=.done"), 10000L)).to("mock:result");
            }
        };
    }
}

