/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnrichBridgeErrorHandlerTest
extends ContextTestSupport {
    private final MyPollingStrategy myPoll = new MyPollingStrategy();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myPoll", (Object)this.myPoll);
        return jndi;
    }

    @Test
    public void testPollEnrichBridgeErrorHandler() throws Exception {
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.myPoll.getCounter());
        Exception caught = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)caught);
        Assertions.assertTrue((boolean)caught.getMessage().startsWith("Error during poll"));
        Assertions.assertEquals((Object)"Something went wrong", (Object)caught.getCause().getCause().getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(3).redeliveryDelay(0L));
                ((RouteDefinition)this.from("seda:start").pollEnrich(PollEnrichBridgeErrorHandlerTest.this.fileUri("?initialDelay=0&delay=10&pollStrategy=#myPoll&bridgeErrorHandler=true"), 10000L, (AggregationStrategy)new UseLatestAggregationStrategy())).to("mock:result");
            }
        };
    }

    private static class MyPollingStrategy
    implements PollingConsumerPollStrategy {
        private int counter;

        private MyPollingStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            ++this.counter;
            throw new IllegalArgumentException("Something went wrong");
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) {
            return false;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

