/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.enricher.FailureProcessor;
import org.apache.camel.processor.enricher.SampleAggregator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EnricherTest
extends ContextTestSupport {
    private static final SampleAggregator aggregationStrategy = new SampleAggregator();
    protected MockEndpoint mock;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mock = this.getMockEndpoint("mock:mock");
    }

    @Test
    public void testEnrichInOnly() throws InterruptedException {
        this.mock.expectedBodiesReceived(new Object[]{"test:blah"});
        ((MockValueBuilder)this.mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://mock");
        this.template.sendBody("direct:enricher-test-1", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    @Test
    public void testEnrichErrorInOnly() throws InterruptedException {
        this.mock.expectedMessageCount(0);
        Exchange exchange = this.template.send("direct:enricher-test-4", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        this.mock.assertIsSatisfied();
        Assertions.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)"failed", (Object)exchange.getException().getMessage());
        Assertions.assertFalse((boolean)exchange.hasOut());
    }

    @Test
    public void testEnrichInOut() {
        String result = (String)this.template.sendBody("direct:enricher-test-5", ExchangePattern.InOut, (Object)"test");
        Assertions.assertEquals((Object)"test:blah", (Object)result);
    }

    @Test
    public void testEnrichInOutPlusHeader() {
        Exchange exchange = this.template.send("direct:enricher-test-5", ExchangePattern.InOut, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.getIn().setBody((Object)"test");
            }
        });
        Assertions.assertEquals((Object)"bar", (Object)exchange.getIn().getHeader("foo"));
        Assertions.assertEquals((Object)"test:blah", (Object)exchange.getIn().getBody());
        Assertions.assertTrue((boolean)exchange.hasOut());
        Assertions.assertNull((Object)exchange.getException());
    }

    @Test
    public void testEnrichErrorInOut() {
        Exchange exchange = this.template.send("direct:enricher-test-8", ExchangePattern.InOut, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        Assertions.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)"failed", (Object)exchange.getException().getMessage());
        Assertions.assertFalse((boolean)exchange.hasOut());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:enricher-test-1").enrich("direct:enricher-constant-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-3").enrich("direct:enricher-fault-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-4").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).enrich("direct:enricher-error-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                this.from("direct:enricher-test-5").enrich("direct:enricher-constant-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-test-7").enrich("direct:enricher-fault-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-test-8").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).enrich("direct:enricher-error-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-constant-resource").transform().constant((Object)"blah");
                this.from("direct:enricher-error-resource").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).process((Processor)new FailureProcessor());
            }
        };
    }
}

