/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnricherSendEventTest
extends ContextTestSupport {
    private final MyEventNotifier en = new MyEventNotifier();

    @Test
    public void testAsyncEnricher() {
        this.template.sendBody("direct:start1", (Object)"test");
        Assertions.assertEquals((int)3, (int)this.en.exchangeSendingEvent.get(), (String)"Get a wrong sending event number");
        Assertions.assertEquals((int)3, (int)this.en.exchangeSentEvent.get(), (String)"Get a wrong sent event number");
    }

    @Test
    public void testSyncEnricher() {
        this.template.sendBody("direct:start2", (Object)"test");
        Assertions.assertEquals((int)3, (int)this.en.exchangeSendingEvent.get(), (String)"Get a wrong sending event number");
        Assertions.assertEquals((int)3, (int)this.en.exchangeSentEvent.get(), (String)"Get a wrong sent event number");
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        ShutdownStrategy shutdownStrategy = camelContext.getShutdownStrategy();
        camelContext.addComponent("async", (Component)new MyAsyncComponent());
        shutdownStrategy.setTimeout(1000L);
        shutdownStrategy.setTimeUnit(TimeUnit.MILLISECONDS);
        shutdownStrategy.setShutdownNowOnTimeout(true);
        DefaultManagementStrategy managementStrategy = new DefaultManagementStrategy();
        managementStrategy.addEventNotifier((EventNotifier)this.en);
        camelContext.setManagementStrategy((ManagementStrategy)managementStrategy);
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start1").enrich("async:out?reply=Reply")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").enrich("direct:result")).to("mock:result");
                this.from("direct:result").setBody((Expression)this.constant("result"));
            }
        };
    }

    static class MyEventNotifier
    extends EventNotifierSupport {
        final AtomicInteger exchangeSendingEvent = new AtomicInteger();
        final AtomicInteger exchangeSentEvent = new AtomicInteger();

        MyEventNotifier() {
        }

        public void notify(CamelEvent event) {
            if (event instanceof CamelEvent.ExchangeSendingEvent) {
                this.exchangeSendingEvent.incrementAndGet();
            } else if (event instanceof CamelEvent.ExchangeSentEvent) {
                this.exchangeSentEvent.incrementAndGet();
            }
        }
    }
}

