/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnricherRefBeanClassTest
extends ContextTestSupport {
    private final MockEndpoint cool;

    public EnricherRefBeanClassTest() {
        this.cool = new MockEndpoint("mock:cool", (Component)new MockComponent((CamelContext)this.context));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("cool", (Object)this.cool);
        return jndi;
    }

    @Test
    public void testEnrichRef() throws Exception {
        this.cool.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                exchange.getMessage().setBody((Object)"Bye World");
            }
        });
        this.cool.expectedBodiesReceived(new Object[]{"Hello World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.cool.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                EnricherRefBeanClassTest.this.cool.setCamelContext((CamelContext)EnricherRefBeanClassTest.this.context);
                ((EnrichDefinition)this.from("direct:start").enrich().simple("ref:cool")).aggregationStrategy("#class:org.apache.camel.processor.aggregate.UseLatestAggregationStrategy");
            }
        };
    }
}

