/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnricherCorrelationIdTest
extends ContextTestSupport {
    EnricherCorrelationIdTest() {
    }

    @Test
    void testCorrelationIdIsNotOverwrittenByEnricher() {
        String originalCorrelationId = "SOME_ID";
        Exchange exchange = this.template.request("direct:start", e -> e.setProperty("CamelCorrelationId", (Object)originalCorrelationId));
        Assertions.assertEquals((Object)"enrichment", (Object)exchange.getMessage().getBody(String.class));
        Assertions.assertEquals((Object)originalCorrelationId, (Object)exchange.getProperty("CamelCorrelationId"));
    }

    @Test
    void testCorrelationIdIsNotOverwrittenByEnricherfailedResource() {
        String originalCorrelationId = "SOME_ID";
        Exchange exchange = this.template.request("direct:failed-resource", e -> e.setProperty("CamelCorrelationId", (Object)originalCorrelationId));
        Assertions.assertEquals((Object)originalCorrelationId, (Object)exchange.getProperty("CamelCorrelationId"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").enrich("direct:enrich");
                this.from("direct:enrich").setBody((Expression)this.constant("enrichment"));
                this.from("direct:failed-resource").enrich("direct:failure");
                this.from("direct:failure").throwException((Exception)new RuntimeException("Fail"));
            }
        };
    }
}

