/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.ShutdownStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnricherAsyncUnhandledExceptionTest
extends ContextTestSupport {
    @Test
    public void testInOutWithRequestBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:pickedUp");
        mock.expectedMessageCount(1);
        try {
            CompletableFuture obj = this.template.asyncRequestBody("direct:in", (Object)"Hello World");
            obj.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            boolean b3 = e instanceof ExecutionException;
            Assertions.assertTrue((boolean)b3);
            boolean b2 = e.getCause() instanceof CamelExecutionException;
            Assertions.assertTrue((boolean)b2);
            boolean b1 = e.getCause().getCause() instanceof CamelExchangeException;
            Assertions.assertTrue((boolean)b1);
            boolean b = e.getCause().getCause().getCause() instanceof RuntimeException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertEquals((Object)"Bang! Unhandled exception", (Object)e.getCause().getCause().getCause().getMessage());
            mock.assertIsSatisfied();
            return;
        }
        Assertions.fail((String)"Expected an RuntimeException");
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        ShutdownStrategy shutdownStrategy = camelContext.getShutdownStrategy();
        camelContext.addComponent("async", (Component)new MyAsyncComponent());
        shutdownStrategy.setTimeout(1000L);
        shutdownStrategy.setTimeUnit(TimeUnit.MILLISECONDS);
        shutdownStrategy.setShutdownNowOnTimeout(true);
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:in").to("mock:pickedUp")).enrich("async:out?reply=Reply", new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        throw new RuntimeException("Bang! Unhandled exception");
                    }
                });
            }
        };
    }
}

