/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StreamCachingStrategy;
import org.junit.jupiter.api.Test;

public class EnricherAggregateStreamingTest
extends ContextTestSupport {
    @Test
    public void testStream() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Old Body New Body"});
        this.template.sendBody("direct:start", (Object)"");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testStreamSync() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Old Body New Body"});
        this.template.sendBody("direct:startSync", (Object)"");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("b1", (Object)new MyProcessor());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().setStreamCaching(Boolean.TRUE);
                StreamCachingStrategy scs = this.getContext().getStreamCachingStrategy();
                scs.setSpoolThreshold(1L);
                scs.setSpoolDirectory(EnricherAggregateStreamingTest.this.testDirectory().toFile());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process((Processor)new StreamProcessor())).enrich("direct:foo", (AggregationStrategy)new MyAggregationStrategy(), false)).to("mock:result");
                this.from("direct:foo").bean((Object)new MyProcessor());
                ((EnrichDefinition)((RouteDefinition)this.from("direct:startSync").process((Processor)new StreamProcessor())).enrich().simple("bean:b1")).aggregationStrategy((AggregationStrategy)new MyAggregationStrategy()).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getIn().getBody(String.class);
            exchange.getIn().setBody((Object)"New Body");
        }
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String oldbody = (String)oldExchange.getIn().getBody(String.class);
            String newbody = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(oldbody + newbody));
            return oldExchange;
        }
    }

    public static class StreamProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            try (CachedOutputStream os = new CachedOutputStream(exchange);){
                os.write("Old Body ".getBytes(StandardCharsets.UTF_8));
                InputStream is = os.getInputStream();
                exchange.getIn().setBody((Object)is);
            }
        }
    }
}

