/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.dynamicrouter;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.RepeatedTest;

@Disabled(value="Manual test together with DynamicRouterConcurrentPOJOTest")
public class DynamicRouterConcurrentEIPManualTest
extends ContextTestSupport {
    private static final int COUNT = 100;

    @RepeatedTest(value=100)
    public void testConcurrentDynamicRouter() throws Exception {
        MockEndpoint mockA = this.getMockEndpoint("mock:a");
        mockA.expectedMessageCount(100);
        MockEndpoint mockB = this.getMockEndpoint("mock:b");
        mockB.expectedMessageCount(100);
        Thread sendToSedaA = this.createSedaSenderThread("seda:a", this.context.createProducerTemplate());
        Thread sendToSedaB = this.createSedaSenderThread("seda:b", this.context.createProducerTemplate());
        sendToSedaA.start();
        sendToSedaB.start();
        sendToSedaA.join(10000L);
        sendToSedaB.join(10000L);
        Awaitility.waitAtMost((long)10L, (TimeUnit)TimeUnit.SECONDS).until(() -> mockA.getReceivedCounter() + mockB.getReceivedCounter() == 200);
        ((AbstractListAssert)Assertions.assertThat((List)mockA.getReceivedExchanges()).map(Exchange::getMessage).map(m -> (String)m.getBody(String.class)).filteredOn(body -> body.contains("Message from seda:b"))).as("Expected mock:a to contain only messages from seda:a, but there were also messages from seda:b", new Object[0]).isEmpty();
        ((AbstractListAssert)Assertions.assertThat((List)mockB.getReceivedExchanges()).map(Exchange::getMessage).map(m -> (String)m.getBody(String.class)).filteredOn(body -> body.contains("Message from seda:a"))).as("Expected mock:b to contain only messages from seda:b, but there were also messages from seda:a", new Object[0]).isEmpty();
        Assertions.assertThat((int)mockA.getReceivedCounter()).isEqualTo(100);
        Assertions.assertThat((int)mockB.getReceivedCounter()).isEqualTo(100);
    }

    private Thread createSedaSenderThread(final String seda, final ProducerTemplate perThreadtemplate) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    perThreadtemplate.sendBody(seda, (Object)("Message from " + seda + " " + i));
                }
            }
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MyDynamicRouterPojo a = new MyDynamicRouterPojo("mock:a");
                MyDynamicRouterPojo b = new MyDynamicRouterPojo("mock:b");
                this.from("seda:a").dynamicRouter((Expression)this.method(a, "route"));
                this.from("seda:b").dynamicRouter((Expression)this.method(b, "route"));
            }
        };
    }

    public static class MyDynamicRouterPojo {
        private final String target;

        public MyDynamicRouterPojo(String target) {
            this.target = target;
        }

        public String route(@Header(value="CamelSlipEndpoint") String previous) {
            if (previous == null) {
                return this.target;
            }
            return null;
        }
    }
}

