/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.converter;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.NoSuchVariableException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class ConvertVariableTest
extends ContextTestSupport {
    private FluentProducerTemplate fluent;

    @BeforeEach
    public void setupTemplate() {
        this.fluent = this.context.createFluentProducerTemplate();
    }

    @Test
    public void testConvertBodyTo() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.from("direct:invalid").convertVariableTo("foo", String.class, "ASSI")).to("mock:endpoint");
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            ConvertVariableTest.assertIsInstanceOf(UnsupportedCharsetException.class, e.getCause());
        }
    }

    @Test
    public void testConvertBodyCharset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertVariableTo("foo", byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isNull();
        this.fluent.to("direct:foo").withVariable("foo", (Object)"Hello World").send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertBodyCharsetWithExistingCharsetName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertVariableTo("foo", byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isEqualTo((Object)"UTF-8");
        this.fluent.to("direct:foo").withVariable("foo", (Object)"Hello World").withExchangeProperty("CamelCharsetName", (Object)"UTF-8").send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToInteger() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)11);
        this.fluent.to("direct:start").withVariable("foo", (Object)11).send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToName() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)"11");
        result.expectedVariableReceived("bar", (Object)11);
        ((MockValueBuilder)result.message(0).variable("foo")).isInstanceOf(String.class);
        ((MockValueBuilder)result.message(0).variable("bar")).isInstanceOf(Integer.class);
        this.fluent.to("direct:bar").withVariable("foo", (Object)"11").send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToIntegerNotMandatory() throws Exception {
        Exchange out = this.fluent.to("direct:start").withVariable("foo", (Object)Double.NaN).send();
        Assertions.assertTrue((boolean)out.isFailed());
        ConvertVariableTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, out.getException());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.fluent.to("direct:optional").withVariable("foo", (Object)Double.NaN).send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertNullBody() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        Exchange out = this.fluent.to("direct:start").withVariable("foo", null).send();
        Assertions.assertTrue((boolean)out.isFailed());
        NoSuchVariableException nv = ConvertVariableTest.assertIsInstanceOf(NoSuchVariableException.class, out.getException());
        Assertions.assertEquals((Object)"foo", (Object)nv.getVariableName());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.fluent.to("direct:invalid").withVariable("foo", (Object)"11").send();
        Assertions.assertTrue((boolean)out.isFailed());
        ConvertVariableTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, out.getException());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.ISO_8859_1);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)body);
        this.fluent.to("direct:charset").withVariable("foo", (Object)"Hello World").send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToStringCharset() throws Exception {
        String body = "Hello World";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)body);
        this.fluent.to("direct:charset3").withVariable("foo", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_16))).send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharsetFail() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.UTF_8);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)body);
        result.expectedMessageCount(1);
        this.fluent.to("direct:charset2").withVariable("foo", (Object)"Hello World").send();
        result.assertIsNotSatisfied();
    }

    @DisabledOnOs(value={OS.AIX})
    @Test
    public void testConvertToStringCharsetFail() throws Exception {
        String body = "Hell\u00f6 W\u00f6rld";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedVariableReceived("foo", (Object)body);
        result.expectedMessageCount(1);
        this.fluent.to("direct:charset3").withVariable("foo", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8))).send();
        result.assertIsNotSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").convertVariableTo("foo", Integer.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:optional").convertVariableTo("foo", Integer.class, false)).to("mock:result");
                ((RouteDefinition)this.from("direct:invalid").convertVariableTo("foo", Date.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:charset").convertVariableTo("foo", byte[].class, "iso-8859-1")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset2").convertVariableTo("foo", byte[].class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset3").convertVariableTo("foo", String.class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").convertVariableTo("foo", "bar", Integer.class)).to("mock:result");
            }
        };
    }
}

