/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.converter;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class ConvertHeaderTest
extends ContextTestSupport {
    @Test
    public void testConvertBodyTo() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.from("direct:invalid").convertHeaderTo("foo", String.class, "ASSI")).to("mock:endpoint");
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            ConvertHeaderTest.assertIsInstanceOf(UnsupportedCharsetException.class, e.getCause());
        }
    }

    @Test
    public void testConvertBodyCharset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertHeaderTo("foo", byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isNull();
        this.template.sendBodyAndHeader("direct:foo", null, "foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertBodyCharsetWithExistingCharsetName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertHeaderTo("foo", byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isEqualTo((Object)"UTF-8");
        Exchange srcExchange = ExchangeBuilder.anExchange((CamelContext)this.context).withProperty("CamelCharsetName", (Object)"UTF-8").withHeader("foo", (Object)"Hello World").build();
        this.template.send("direct:foo", srcExchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToInteger() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)11);
        this.template.sendBodyAndHeader("direct:start", null, "foo", (Object)11);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToName() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)"11");
        result.expectedHeaderReceived("bar", (Object)11);
        ((MockValueBuilder)result.message(0).header("foo")).isInstanceOf(String.class);
        ((MockValueBuilder)result.message(0).header("bar")).isInstanceOf(Integer.class);
        this.template.sendBodyAndHeader("direct:bar", null, "foo", (Object)"11");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToIntegerNotMandatory() throws Exception {
        try {
            this.template.sendBodyAndHeader("direct:start", null, "foo", (Object)Double.NaN);
            Assertions.fail();
        }
        catch (Exception e) {
            ConvertHeaderTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause());
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.template.sendBodyAndHeader("direct:optional", null, "foo", (Object)Double.NaN);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertNullBody() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((MockValueBuilder)result.message(0).header("foo")).isNull();
        this.template.sendBodyAndHeader("direct:start", null, "foo", null);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:invalid", null, "foo", (Object)"11");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof NoTypeConversionAvailableException;
            Assertions.assertTrue((boolean)b);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.ISO_8859_1);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)body);
        this.template.sendBodyAndHeader("direct:charset", null, "foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToStringCharset() throws Exception {
        String body = "Hello World";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)body);
        this.template.sendBodyAndHeader("direct:charset3", null, "foo", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_16)));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharsetFail() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.UTF_8);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)body);
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:charset2", null, "foo", (Object)"Hello World");
        result.assertIsNotSatisfied();
    }

    @DisabledOnOs(value={OS.AIX})
    @Test
    public void testConvertToStringCharsetFail() throws Exception {
        String body = "Hell\u00f6 W\u00f6rld";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedHeaderReceived("foo", (Object)body);
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:charset3", null, "foo", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        result.assertIsNotSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").convertHeaderTo("foo", Integer.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:optional").convertHeaderTo("foo", Integer.class, false)).to("mock:result");
                ((RouteDefinition)this.from("direct:invalid").convertHeaderTo("foo", Date.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:charset").convertHeaderTo("foo", byte[].class, "iso-8859-1")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset2").convertHeaderTo("foo", byte[].class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset3").convertHeaderTo("foo", String.class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").convertHeaderTo("foo", "bar", Integer.class)).to("mock:result");
            }
        };
    }
}

