/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.converter;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.converter.custom.MyBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class ConvertBodyTest
extends ContextTestSupport {
    @Test
    public void testConvertBodyTo() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.from("direct:invalid").convertBodyTo(String.class, "ASSI")).to("mock:endpoint");
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            ConvertBodyTest.assertIsInstanceOf(UnsupportedCharsetException.class, e.getCause());
        }
    }

    @Test
    public void testConvertBodyCharset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertBodyTo(byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isNull();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertBodyCharsetWithExistingCharsetName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertBodyTo(byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isEqualTo((Object)"UTF-8");
        Exchange srcExchange = ExchangeBuilder.anExchange((CamelContext)this.context).withProperty("CamelCharsetName", (Object)"UTF-8").withBody((Object)"Hello World").build();
        this.template.send("direct:foo", srcExchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToInteger() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{11});
        this.template.sendBody("direct:start", (Object)"11");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToIntegerNotMandatory() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)Double.NaN);
            Assertions.fail();
        }
        catch (Exception e) {
            ConvertBodyTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.template.sendBody("direct:optional", (Object)Double.NaN);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertNullBody() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((MockValueBuilder)result.message(0).body()).isNull();
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:invalid", (Object)"11");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof InvalidPayloadException;
            Assertions.assertTrue((boolean)b);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.ISO_8859_1);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToStringCharset() throws Exception {
        String body = "Hello World";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset3", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_16)));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConvertToBytesCharsetFail() throws Exception {
        byte[] body = "Hello World".getBytes(StandardCharsets.UTF_8);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset2", (Object)"Hello World");
        result.assertIsNotSatisfied();
    }

    @DisabledOnOs(value={OS.AIX})
    @Test
    public void testConvertToStringCharsetFail() throws Exception {
        String body = "Hell\u00f6 W\u00f6rld";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset3", (Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        result.assertIsNotSatisfied();
    }

    @Test
    public void testLoadedCustomConverter() throws InterruptedException {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{new MyBean("foo", "bar")});
        this.template.sendBody("direct:loadedCustomConverter", (Object)"foo:bar");
        result.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").convertBodyTo(Integer.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:optional").convertBodyTo(Integer.class, false)).to("mock:result");
                ((RouteDefinition)this.from("direct:invalid").convertBodyTo(Date.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:charset").convertBodyTo(byte[].class, "iso-8859-1")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset2").convertBodyTo(byte[].class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset3").convertBodyTo(String.class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:loadedCustomConverter").convertBodyTo(MyBean.class)).to("mock:result");
            }
        };
    }
}

