/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.processor.async.MyAsyncEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAsyncProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MyAsyncProducer.class);
    private final ExecutorService executor;
    private final AtomicInteger counter = new AtomicInteger();

    public MyAsyncProducer(MyAsyncEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.executor = endpoint.getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MyProducer");
    }

    public MyAsyncEndpoint getEndpoint() {
        return (MyAsyncEndpoint)super.getEndpoint();
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LOG.info("Simulating a task which takes {} millis to reply", (Object)MyAsyncProducer.this.getEndpoint().getDelay());
                Thread.sleep(MyAsyncProducer.this.getEndpoint().getDelay());
                int count = MyAsyncProducer.this.counter.incrementAndGet();
                if (MyAsyncProducer.this.getEndpoint().getFailFirstAttempts() >= count) {
                    LOG.info("Simulating a failure at attempt {}", (Object)count);
                    exchange.setException((Throwable)new CamelExchangeException("Simulated error at attempt " + count, exchange));
                } else {
                    String reply = MyAsyncProducer.this.getEndpoint().getReply();
                    reply = MyAsyncProducer.this.getEndpoint().isAppend() ? String.valueOf(exchange.getIn().getBody()) + " " + reply : reply;
                    exchange.getMessage().setBody((Object)reply);
                    LOG.info("Setting reply {}", (Object)reply);
                }
                LOG.info("Callback done(false)");
                callback.done(false);
                return null;
            }
        });
        LOG.info("Task submitted, now tell Camel routing engine to that this Exchange is being continued asynchronously");
        return false;
    }
}

