/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsyncRouteWithErrorTest
extends ContextTestSupport {
    private static String route = "";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        route = "";
    }

    @Test
    public void testAsyncRouteWithError() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Damn forced by unit test", (Object)e.getCause().getMessage());
        }
        route = route + "A";
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"BA", (Object)route);
    }

    @Test
    public void testAsyncRouteWithTypeConverted() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello", String.class);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Damn forced by unit test", (Object)e.getCause().getMessage());
        }
        route = route + "A";
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"BA", (Object)route);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ThreadsDefinition)((RouteDefinition)this.from("direct:start").transform((Expression)this.body().append((Object)" World"))).threads().to("mock:foo")).delay(100L).process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            route = route + "B";
            Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
            throw new IllegalArgumentException("Damn forced by unit test");
        }
    }
}

