/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.support.PluginHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncProcessorAwaitManagerTest
extends ContextTestSupport {
    @Test
    public void testAsyncAwait() throws Exception {
        AsyncProcessorAwaitManager asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.context);
        asyncProcessorAwaitManager.getStatistics().setStatisticsEnabled(true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsBlocked());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsInterrupted());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncProcessorAwaitManagerTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:before")).to("async:bye:camel")).id("myAsync")).to("mock:after")).process(new Processor(){

                    public void process(Exchange exchange) {
                        int size = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)AsyncProcessorAwaitManagerTest.this.context).size();
                        log.info("async inflight: {}", (Object)size);
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)size);
                        Collection threads = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)AsyncProcessorAwaitManagerTest.this.context).browse();
                        AsyncProcessorAwaitManager.AwaitThread thread = (AsyncProcessorAwaitManager.AwaitThread)threads.iterator().next();
                        long wait = thread.getWaitDuration();
                        log.info("Thread {} has waited for {} msec.", (Object)thread.getBlockedThread().getName(), (Object)wait);
                        org.junit.jupiter.api.Assertions.assertEquals((Object)"myRoute", (Object)thread.getRouteId());
                        Assertions.assertThat((String)thread.getNodeId()).matches((CharSequence)"process[0-9]+");
                    }
                })).to("mock:result");
            }
        };
    }
}

