/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class AsyncProcessorAwaitManagerInterruptWithRedeliveryTest
extends ContextTestSupport {
    private MyBean bean;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.bean = (MyBean)Mockito.spy((Object)new MyBean());
        super.setUp();
    }

    @Test
    public void testAsyncAwaitInterrupt() throws Exception {
        AsyncProcessorAwaitManager asyncProcessorAwaitManager;
        block2: {
            asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.context);
            asyncProcessorAwaitManager.getStatistics().setStatisticsEnabled(true);
            Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
            this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
            this.getMockEndpoint("mock:result").expectedMessageCount(0);
            this.getMockEndpoint("mock:error").expectedMessageCount(0);
            this.createThreadToInterrupt();
            try {
                this.template.sendBody("direct:start", (Object)"Hello Camel");
                Assertions.fail((String)"Should throw exception");
            }
            catch (CamelExecutionException e) {
                Throwable cause = e.getCause();
                boolean interrupted = cause.getMessage().startsWith("Interrupted while waiting for asynchronous callback");
                if (interrupted) break block2;
                this.log.warn("Did not find exception caused exception", cause);
            }
        }
        this.assertMockEndpointsSatisfied();
        ((MyBean)Mockito.verify((Object)this.bean, (VerificationMode)Mockito.atMost((int)4))).callMe();
        Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
        Assertions.assertEquals((long)1L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsBlocked());
        Assertions.assertEquals((long)1L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsInterrupted());
    }

    private void createThreadToInterrupt() {
        new Thread(() -> {
            AsyncProcessorAwaitManager asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.context);
            Awaitility.await().untilAsserted(() -> {
                int size = asyncProcessorAwaitManager.size();
                Assertions.assertEquals((int)1, (int)size);
                Collection threads = asyncProcessorAwaitManager.browse();
                AsyncProcessorAwaitManager.AwaitThread thread = (AsyncProcessorAwaitManager.AwaitThread)threads.iterator().next();
                String id = thread.getExchange().getExchangeId();
                asyncProcessorAwaitManager.interrupt(id);
            });
        }).start();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(5).redeliveryDelay(750L).asyncDelayedRedelivery());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:before")).bean((Object)"myBean", "callMe")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void callMe() throws Exception {
            throw new Exception();
        }
    }
}

