/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncProcessorAwaitManagerInterruptTest
extends ContextTestSupport {
    @Test
    public void testAsyncAwaitInterrupt() throws Exception {
        AsyncProcessorAwaitManager asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.context);
        asyncProcessorAwaitManager.getStatistics().setStatisticsEnabled(true);
        Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        }
        catch (CamelExecutionException e) {
            RejectedExecutionException cause = AsyncProcessorAwaitManagerInterruptTest.assertIsInstanceOf(RejectedExecutionException.class, e.getCause());
            Assertions.assertTrue((boolean)cause.getMessage().startsWith("Interrupted while waiting for asynchronous callback"));
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)asyncProcessorAwaitManager.size());
        Assertions.assertEquals((long)1L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsBlocked());
        Assertions.assertEquals((long)1L, (long)asyncProcessorAwaitManager.getStatistics().getThreadsInterrupted());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncProcessorAwaitManagerInterruptTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:before")).to("async:bye:camel?delay=2000")).id("myAsync")).to("mock:after")).process(new Processor(){

                    public void process(Exchange exchange) {
                        AsyncProcessorAwaitManager asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)AsyncProcessorAwaitManagerInterruptTest.this.context);
                        int size = asyncProcessorAwaitManager.size();
                        log.info("async inflight: {}", (Object)size);
                        Assertions.assertEquals((int)1, (int)size);
                        Collection threads = asyncProcessorAwaitManager.browse();
                        AsyncProcessorAwaitManager.AwaitThread thread = (AsyncProcessorAwaitManager.AwaitThread)threads.iterator().next();
                        String id = thread.getExchange().getExchangeId();
                        asyncProcessorAwaitManager.interrupt(id);
                    }
                })).transform((Expression)this.constant("Hi Camel"))).to("mock:result");
            }
        };
    }
}

