/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class AsyncMDCTest
extends ContextTestSupport {
    @Test
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThreeMessagesMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel", "Bye Camel"});
        this.log.info("#1 message");
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.log.info("#2 message");
        this.template.sendBody("direct:a", (Object)"Hello Camel");
        this.log.info("#3 message");
        this.template.sendBody("direct:a", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncMDCTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                AsyncMDCTest.this.context.setUseBreadcrumb(Boolean.valueOf(true));
                AsyncMDCTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)exchange.getContext().getName(), (Object)MDC.get((String)"camel.contextId"));
                        Assertions.assertEquals((Object)exchange.getIn().getHeader("breadcrumbId"), (Object)MDC.get((String)"camel.breadcrumbId"));
                        Assertions.assertNotNull((Object)MDC.get((String)"camel.breadcrumbId"));
                    }
                })).to("log:before")).to("async:bye:camel")).to("log:after")).to("direct:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-b", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

