/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointUoWFailedTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;
    private final MySynchronization sync = new MySynchronization();

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AsyncEndpointUoWFailedTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
        Assertions.assertEquals((int)0, (int)this.sync.isOnComplete());
        Assertions.assertEquals((int)1, (int)this.sync.isOnFailure());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointUoWFailedTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)AsyncEndpointUoWFailedTest.this.sync);
                    }
                })).to("mock:before")).to("log:before")).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:result");
            }
        };
    }

    private static class MySynchronization
    extends SynchronizationAdapter {
        private final AtomicInteger onComplete = new AtomicInteger();
        private final AtomicInteger onFailure = new AtomicInteger();

        private MySynchronization() {
        }

        public void onComplete(Exchange exchange) {
            this.onComplete.incrementAndGet();
        }

        public void onFailure(Exchange exchange) {
            this.onFailure.incrementAndGet();
        }

        public int isOnComplete() {
            return this.onComplete.get();
        }

        public int isOnFailure() {
            return this.onFailure.get();
        }
    }
}

