/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.HashSet;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointTryCatchFinally3Test
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String middleThreadName;
    private static String afterThreadName;
    private static String resultThreadName;

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:catch").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        HashSet<String> names = new HashSet<String>();
        names.add(beforeThreadName);
        names.add(middleThreadName);
        names.add(afterThreadName);
        names.add(resultThreadName);
        Assertions.assertEquals((int)4, (int)names.size(), (String)"Should use 4 different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointTryCatchFinally3Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).doTry().process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel?failFirstAttempts=1")).doCatch(Exception.class).to("log:catch")).to("mock:catch")).process(new Processor(){

                    public void process(Exchange exchange) {
                        middleThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:world")).doFinally().process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("async:bye:camel")).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        resultThreadName = Thread.currentThread().getName();
                    }
                }).to("log:result").to("mock:result");
            }
        };
    }
}

