/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsyncEndpointSedaInOnlyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;
    private static String sedaThreadName;
    private static String route;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        route = "";
    }

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        route = route + "A";
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(sedaThreadName), (String)"Should use different threads");
        Assertions.assertFalse((boolean)afterThreadName.equalsIgnoreCase(sedaThreadName), (String)"Should use different threads");
        Assertions.assertEquals((Object)"AB", (Object)route);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointSedaInOnlyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("seda:foo");
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("seda:foo").to("mock:after")).to("log:after")).delay(1000L).process(new Processor(){

                    public void process(Exchange exchange) {
                        route = route + "B";
                        sedaThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:result");
            }
        };
    }

    static {
        route = "";
    }
}

