/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RoutingSlip;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class AsyncEndpointRoutingSlipBeanNonBlockingTest
extends ContextTestSupport {
    private AsyncCallback innerCallback;
    private Exchange innerExchange;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyRoutingSlipBean());
        return jndi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncEndpointDontBlock() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        Endpoint startEndpoint = this.context.getEndpoint("direct:start");
        SendProcessor asyncSender = new SendProcessor(startEndpoint);
        ServiceHelper.startService((Service)asyncSender);
        ExecutorService executorService = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "test");
        try {
            Future<Boolean> asyncFuture = executorService.submit(new ExchangeSubmitter(startEndpoint, asyncSender));
            Assertions.assertFalse((boolean)asyncFuture.get(5L, TimeUnit.SECONDS));
            this.innerExchange.getMessage().setBody((Object)"Bye Camel");
            this.innerCallback.done(false);
            this.assertMockEndpointsSatisfied();
        }
        finally {
            executorService.shutdown();
            ServiceHelper.stopAndShutdownService((ShutdownableService)asyncSender);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointRoutingSlipBeanNonBlockingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").to("bean:myBean");
                this.from("direct:asyncRoute").process((Processor)new MyAsyncProcessor());
            }
        };
    }

    public static class MyRoutingSlipBean {
        @RoutingSlip
        public String doSomething() {
            return "direct:asyncRoute,mock:result";
        }
    }

    private static class ExchangeSubmitter
    implements Callable<Boolean> {
        private final Endpoint startEndpoint;
        private final SendProcessor asyncSender;

        ExchangeSubmitter(Endpoint startEndpoint, SendProcessor asyncSender) {
            this.startEndpoint = startEndpoint;
            this.asyncSender = asyncSender;
        }

        @Override
        public Boolean call() {
            Exchange exchange = this.startEndpoint.createExchange(ExchangePattern.InOut);
            exchange.getIn().setBody((Object)"Hello Camel");
            return this.asyncSender.process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    Assertions.assertFalse((boolean)doneSync);
                }
            });
        }
    }

    private class MyAsyncProcessor
    extends AsyncProcessorSupport {
        private MyAsyncProcessor() {
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            AsyncEndpointRoutingSlipBeanNonBlockingTest.this.innerCallback = callback;
            AsyncEndpointRoutingSlipBeanNonBlockingTest.this.innerExchange = exchange;
            return false;
        }
    }
}

