/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointRoutingSlipBean2Test
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyRoutingSlipBean());
        return jndi;
    }

    @Test
    public void testAsyncEndpoint() {
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointRoutingSlipBean2Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").bean((Object)"myBean");
            }
        };
    }

    public static class MyRoutingSlipBean {
        @RoutingSlip
        public String doSomething() {
            return "async:bye:camel,async:bye:world";
        }
    }
}

