/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEndpointRedeliveryErrorHandlerNonBlockedDelay2Test
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncEndpointRedeliveryErrorHandlerNonBlockedDelay2Test.class);
    private static final LongAdder attempt = new LongAdder();
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testRedelivery() throws Exception {
        MockEndpoint before = this.getMockEndpoint("mock:result");
        before.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("seda:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointRedeliveryErrorHandlerNonBlockedDelay2Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(5).redeliveryDelay(100L).asyncDelayedRedelivery());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:before")).to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:camel")).process(new Processor(){

                    public void process(Exchange exchange) {
                        LOG.info("Processing at attempt {} {}", (Object)attempt, (Object)exchange);
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("Camel")) {
                            attempt.increment();
                            if (attempt.intValue() <= 2) {
                                LOG.info("Processing failed will thrown an exception");
                                throw new IllegalArgumentException("Damn");
                            }
                        }
                        exchange.getIn().setBody((Object)("Hello " + body));
                        LOG.info("Processing at attempt {} complete {}", (Object)attempt, (Object)exchange);
                    }
                })).to("log:after")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:result");
            }
        };
    }
}

