/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointRecipientListFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("fail", (Object)new MyFailBean());
        return jndi;
    }

    @Test
    public void testAsyncEndpointOK() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                AsyncEndpointRecipientListFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).redeliveryDelay(0L).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,async:bye:camel,mock:bar,mock:baz");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncEndpointERROR() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                AsyncEndpointRecipientListFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).redeliveryDelay(0L).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)counter);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyFailBean {
        public String doSomething(Exchange exchange) {
            ++counter;
            Assertions.assertEquals((Object)"bean://fail", (Object)exchange.getProperty("CamelToEndpoint", String.class));
            throw new IllegalArgumentException("Damn");
        }
    }
}

