/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointPolicyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:response").expectedMessageCount(1);
        this.getMockEndpoint("mock:response").expectedHeaderReceived("foo", (Object)"policy finished execution");
        this.template.sendBody("direct:send", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        Assertions.assertEquals((int)1, (int)foo.getInvoked(), (String)"Should only be invoked 1 time");
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointPolicyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy("foo").to("mock:foo")).to("async:bye:camel")).to("mock:bar")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:send").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("direct:start")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:response");
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, final Processor processor) {
            return new AsyncProcessor(){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    ++invoked;
                    exchange.getIn().setHeader(name, (Object)"was wrapped");
                    AsyncProcessor ap = AsyncProcessorConverterHelper.convert((Processor)processor);
                    ap.process(exchange, doneSync -> {
                        exchange.getIn().setHeader(name, (Object)"policy finished execution");
                        callback.done(false);
                    });
                    return false;
                }

                public void process(Exchange exchange) {
                    AsyncProcessorAwaitManager awaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)exchange.getContext());
                    awaitManager.process((AsyncProcessor)this, exchange);
                }

                public CompletableFuture<Exchange> processAsync(Exchange exchange) {
                    AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
                    this.process(exchange, (AsyncCallback)callback);
                    return callback.getFuture();
                }
            };
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

