/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointMulticastSynchronousTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testAsyncEndpoint() {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        Assertions.assertTrue((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use same threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointMulticastSynchronousTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((MulticastDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).multicast().synchronous().to(new String[]{"async:hi:moon", "direct:foo"})).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                }).to("log:after").to("mock:after").to("mock:result");
                this.from("direct:foo").setBody((Expression)this.constant("Bye Camel"));
            }
        };
    }
}

