/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointIdempotentConsumerTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        MockEndpoint after = this.getMockEndpoint("mock:after");
        after.expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel"});
        ((MockValueBuilder)after.message(0).header("myId")).isEqualTo((Object)123);
        ((MockValueBuilder)after.message(1).header("myId")).isEqualTo((Object)456);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel"});
        ((MockValueBuilder)result.message(0).header("myId")).isEqualTo((Object)123);
        ((MockValueBuilder)result.message(1).header("myId")).isEqualTo((Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "myId", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "myId", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "myId", (Object)456);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointIdempotentConsumerTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).idempotentConsumer((Expression)this.header("myId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }
}

