/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointFailureProcessorContinueTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"MyFailureHandler"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"MyFailureHandler"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointFailureProcessorContinueTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).continued(true).to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:MyFailureHandler")).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:result")).transform((Expression)this.constant("Bye Camel"));
            }
        };
    }
}

