/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointEventNotifierTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicLong time = new AtomicLong();

    @Test
    public void testAsyncEndpointEventNotifier() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS), (String)"Should count down");
        long delta = this.time.get();
        this.log.info("ExchangeEventSent took ms: {}", (Object)delta);
        Assertions.assertTrue((delta > 200L ? 1 : 0) != 0, (String)("Should take about 250 millis sec, was: " + delta));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                try {
                    CamelEvent.ExchangeSentEvent sent = (CamelEvent.ExchangeSentEvent)event;
                    AsyncEndpointEventNotifierTest.this.time.set(sent.getTimeTaken());
                }
                finally {
                    AsyncEndpointEventNotifierTest.this.latch.countDown();
                }
            }

            public boolean isEnabled(CamelEvent event) {
                if (event instanceof CamelEvent.ExchangeSentEvent) {
                    CamelEvent.ExchangeSentEvent sent = (CamelEvent.ExchangeSentEvent)event;
                    return sent.getEndpoint().getEndpointUri().startsWith("async");
                }
                return false;
            }
        });
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointEventNotifierTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("async:bye:camel?delay=250")).to("mock:result");
            }
        };
    }
}

