/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointEventNotifierSendingTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Test
    public void testAsyncEndpointEventNotifier() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)this.events.size());
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSendingEvent.class, this.events.get(0));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSendingEvent.class, this.events.get(1));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSentEvent.class, this.events.get(2));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSendingEvent.class, this.events.get(3));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSentEvent.class, this.events.get(4));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSendingEvent.class, this.events.get(5));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSentEvent.class, this.events.get(6));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(CamelEvent.ExchangeSentEvent.class, this.events.get(7));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                AsyncEndpointEventNotifierSendingTest.this.events.add(event);
            }

            public boolean isEnabled(CamelEvent event) {
                return event instanceof CamelEvent.ExchangeSendingEvent || event instanceof CamelEvent.ExchangeSentEvent;
            }
        });
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointEventNotifierSendingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("async:bye:camel?delay=250")).to("mock:result");
            }
        };
    }
}

