/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncEndpointDynamicRouterTest
extends ContextTestSupport {
    private static int invoked;
    private static final List<String> bodies;

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)invoked);
        Assertions.assertEquals((int)4, (int)bodies.size());
        Assertions.assertEquals((Object)"Hello Camel", (Object)bodies.get(0));
        Assertions.assertEquals((Object)"Bye Camel", (Object)bodies.get(1));
        Assertions.assertEquals((Object)"Bye World", (Object)bodies.get(2));
        Assertions.assertEquals((Object)"Bye World", (Object)bodies.get(3));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncEndpointDynamicRouterTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").dynamicRouter((Expression)this.method(AsyncEndpointDynamicRouterTest.class, "slip"));
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }

    public String slip(String body) {
        bodies.add(body);
        if (++invoked == 1) {
            return "async:bye:camel";
        }
        if (invoked == 2) {
            return "direct:foo";
        }
        if (invoked == 3) {
            return "mock:result";
        }
        return null;
    }

    static {
        bodies = new ArrayList<String>();
    }
}

