/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncDirectForceSynchronousTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAsyncEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder(false));
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should NOT use same threads");
    }

    @Test
    public void testAsyncEndpointForced() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder(true));
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use same threads");
    }

    protected RouteBuilder createRouteBuilder(final boolean sync) {
        return new RouteBuilder(){

            public void configure() {
                AsyncDirectForceSynchronousTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("direct:foo?synchronous=" + sync)).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:after");
                this.from("direct:foo").to("async:bye:camel");
            }
        };
    }
}

