/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncDefaultErrorHandlerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAsyncDefaultErrorHandlerWait() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)this.from("direct:in").threads(2).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        try {
            this.template.requestBody("direct:in", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown a CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced exception by unit test", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

