/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.junit.jupiter.api.Test;

public class AsyncDeadLetterChannelExecutorServiceRefTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAsyncErrorHandlerWait() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ThreadPoolProfile profile = new ThreadPoolProfile("myAsyncPool");
                profile.setPoolSize(Integer.valueOf(5));
                AsyncDeadLetterChannelExecutorServiceRefTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false).executorServiceRef("myAsyncPool"));
                ((ThreadsDefinition)this.from("direct:in").threads(2).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.requestBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

