/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class StringAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void testAggregateString() throws Exception {
        Object objectBody = new Object();
        Object objectHeader = new Object();
        this.getMockEndpoint("mock:aggregatedBody").expectedBodiesReceived(new Object[]{"bodyAbodyB" + String.valueOf(objectBody)});
        this.getMockEndpoint("mock:aggregatedBodyComma").expectedBodiesReceived(new Object[]{"bodyA, bodyB, " + String.valueOf(objectBody)});
        this.getMockEndpoint("mock:aggregatedBodyLines").expectedBodiesReceived(new Object[]{"bodyA\nbodyB\n" + String.valueOf(objectBody)});
        this.getMockEndpoint("mock:aggregatedHeader").expectedBodiesReceived(new Object[]{"headerAheaderB" + String.valueOf(objectHeader)});
        this.getMockEndpoint("mock:aggregatedHeaderComma").expectedBodiesReceived(new Object[]{"headerA, headerB, " + String.valueOf(objectHeader)});
        this.getMockEndpoint("mock:aggregatedHeaderLines").expectedBodiesReceived(new Object[]{"headerA\nheaderB\n" + String.valueOf(objectHeader)});
        this.template.sendBodyAndHeader("direct:start", (Object)"bodyA", "header", (Object)"headerA");
        this.template.sendBodyAndHeader("direct:start", (Object)"bodyB", "header", (Object)"headerB");
        this.template.sendBodyAndHeader("direct:start", objectBody, "header", objectHeader);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"direct:aggregateBody", "direct:aggregateBodyComma", "direct:aggregateBodyLines", "direct:aggregateHeader", "direct:aggregateHeaderComma", "direct:aggregateHeaderLines"});
                this.from("direct:aggregateBody").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string()).completionSize(3).to("mock:aggregatedBody");
                this.from("direct:aggregateBodyComma").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string().delimiter(", ")).completionSize(3).to("mock:aggregatedBodyComma");
                this.from("direct:aggregateBodyLines").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string((String)"\n")).completionSize(3).to("mock:aggregatedBodyLines");
                this.from("direct:aggregateHeader").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string().pick((Expression)this.header("header"))).completionSize(3).to("mock:aggregatedHeader");
                this.from("direct:aggregateHeaderComma").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string((String)", ").pick((Expression)this.header("header"))).completionSize(3).to("mock:aggregatedHeaderComma");
                this.from("direct:aggregateHeaderLines").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategies.string().pick((Expression)this.header("header")).delimiter("\n")).completionSize(3).to("mock:aggregatedHeaderLines");
            }
        };
    }
}

