/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitRouteNumberOfProcessorTest
extends ContextTestSupport {
    private static final AtomicBoolean failed = new AtomicBoolean();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOneProcessor() throws Exception {
        failed.set(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(","), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)newExchange.getIn().getBody(String.class);
                        Assertions.assertNotNull((Object)body);
                        return newExchange;
                    }
                }).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertFalse((boolean)failed.get(), (String)"Should not have out");
                        String s = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Hi " + s));
                        SplitRouteNumberOfProcessorTest.this.context.createProducerTemplate().send("mock:foo", exchange);
                    }
                })).end().to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hi Claus", "Hi Willem"});
        this.template.requestBodyAndHeader("direct:start", (Object)"Claus,Willem", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThreeProcessors() throws Exception {
        failed.set(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(","), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)newExchange.getIn().getBody(String.class);
                        Assertions.assertNotNull((Object)body);
                        return newExchange;
                    }
                }).pipeline(new String[]{"log:a", "log:b"})).to("log:foo")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertFalse((boolean)failed.get(), (String)"Should not have out");
                        String s = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Hi " + s));
                        SplitRouteNumberOfProcessorTest.this.context.createProducerTemplate().send("mock:foo", exchange);
                    }
                })).to("mock:split")).end().to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hi Claus", "Hi Willem"});
        this.template.requestBodyAndHeader("direct:start", (Object)"Claus,Willem", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }
}

