/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.GroupedBodyAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitAggregateStackOverflowIssueTest
extends ContextTestSupport {
    private final AtomicInteger count = new AtomicInteger();

    @Test
    public void testStackoverflow() throws Exception {
        int size = 50000;
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(size / 10);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("Line #").append(i);
            sb.append("\n");
        }
        this.template.sendBody("direct:start", (Object)sb);
        MockEndpoint.assertIsSatisfied((long)60L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{result});
        Assertions.assertTrue((this.count.get() < 70 ? 1 : 0) != 0, (String)("Stackframe must not be too high, was " + this.count.get()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((SplitDefinition)this.from("direct:start").split().tokenize("\n")).streaming().to("log:input?groupSize=100")).process(e -> {
                    if ((Integer)e.getProperty("CamelSplitIndex", (Object)0, Integer.TYPE) % 1000 == 0) {
                        int frames = (int)Stream.of(Thread.currentThread().getStackTrace()).filter(st -> !st.getClassName().startsWith("org.junit.")).count();
                        SplitAggregateStackOverflowIssueTest.this.count.set(frames);
                        this.log.info("Stackframe: {}", (Object)frames);
                    }
                })).aggregate((Expression)this.constant("foo"), (AggregationStrategy)new GroupedBodyAggregationStrategy()).completeAllOnStop().eagerCheckCompletion().completionSize(10).completionTimeout(TimeUnit.SECONDS.toMillis(5L)).completionPredicate((Predicate)this.exchangeProperty("CamelSplitComplete")).to(new String[]{"log:result?groupSize=100", "mock:result"});
            }
        };
    }
}

