/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.GroupedBodyAggregationStrategy;
import org.junit.jupiter.api.Test;

public class SplitAggregateParallelProcessingStackOverflowIssueTest
extends ContextTestSupport {
    @Test
    public void testStackoverflow() throws Exception {
        int size = 50000;
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(size / 10);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("Line #").append(i);
            sb.append("\n");
        }
        this.template.sendBody("direct:start", (Object)sb);
        MockEndpoint.assertIsSatisfied((long)60L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{result});
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().tokenize("\n")).streaming().parallelProcessing().aggregate((Expression)this.constant("foo"), (AggregationStrategy)new GroupedBodyAggregationStrategy()).completeAllOnStop().eagerCheckCompletion().completionSize(10).completionTimeout(TimeUnit.SECONDS.toMillis(5L)).completionPredicate((Predicate)this.exchangeProperty("CamelSplitComplete")).to(new String[]{"log:result?groupSize=100", "mock:result"});
            }
        };
    }
}

