/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptimisticLockRetryPolicyTest {
    OptimisticLockRetryPolicyTest() {
    }

    @Test
    void testRandomBackOff() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(true);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(100L);
        for (int i = 0; i < 10; ++i) {
            long delay = this.getDelay(policy, i);
            Assertions.assertTrue((delay <= policy.getMaximumRetryDelay() && delay >= 0L ? 1 : 0) != 0);
        }
    }

    @Test
    void testExponentialBackOff() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(10L);
        for (int i = 0; i < 6; ++i) {
            long delay = this.getDelay(policy, i);
            this.assertDelay(10L << i, delay);
        }
    }

    @Test
    void testExponentialBackOffMaximumRetryDelay() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(100L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 10; ++i) {
            long delay = this.getDelay(policy, i);
            if (i == 0) {
                this.assertDelay(50L, delay);
                continue;
            }
            this.assertDelay(100L, delay);
        }
    }

    @Test
    void testRetryDelay() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 10; ++i) {
            long delay = this.getDelay(policy, i);
            this.assertDelay(50L, delay);
        }
    }

    @Test
    void testMaximumRetries() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setMaximumRetries(2);
        policy.setRetryDelay(50L);
        block3: for (int i = 0; i < 10; ++i) {
            switch (i) {
                case 0: 
                case 1: {
                    Assertions.assertTrue((boolean)policy.shouldRetry(i));
                    continue block3;
                }
                default: {
                    Assertions.assertFalse((boolean)policy.shouldRetry(i));
                }
            }
        }
    }

    private long getDelay(OptimisticLockRetryPolicy policy, int i) {
        return policy.getDelay(i);
    }

    private void assertDelay(long expectedDelay, long actualDelay) {
        Assertions.assertEquals((long)expectedDelay, (long)actualDelay);
    }
}

