/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistributedTimeoutTest
extends AbstractDistributedTest {
    private final MemoryAggregationRepository sharedAggregationRepository = new MemoryAggregationRepository(true);
    private final AtomicInteger invoked = new AtomicInteger();
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    @Test
    public void testAggregateTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:aggregated");
        mock.expectedMessageCount(0);
        mock2.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> this.invoked.get() == 1);
        mock.assertIsSatisfied();
        mock2.assertIsSatisfied();
        Assertions.assertNotNull((Object)this.receivedExchange);
        Assertions.assertEquals((Object)"AB", (Object)this.receivedExchange.getIn().getBody());
        Assertions.assertEquals((int)-1, (int)this.receivedIndex);
        Assertions.assertEquals((int)-1, (int)this.receivedTotal);
        Assertions.assertEquals((long)200L, (long)this.receivedTimeout);
        mock.reset();
        mock.expectedMessageCount(0);
        mock2.reset();
        mock2.expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        Awaitility.await().untilAsserted(() -> {
            mock2.assertIsSatisfied(500L);
            mock.assertIsSatisfied(500L);
        });
        Assertions.assertEquals((int)1, (int)this.invoked.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).aggregationRepository((AggregationRepository)DistributedTimeoutTest.this.sharedAggregationRepository).optimisticLocking().discardOnCompletionTimeout().completionSize(3).completionTimeout(200L).completionTimeoutCheckerInterval(10L).to("mock:aggregated");
            }
        };
    }

    private class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            DistributedTimeoutTest.this.invoked.incrementAndGet();
            DistributedTimeoutTest.this.receivedExchange = oldExchange;
            DistributedTimeoutTest.this.receivedIndex = index;
            DistributedTimeoutTest.this.receivedTotal = total;
            DistributedTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

