/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistributedOptimisticLockFailingTest
extends AbstractDistributedTest {
    private final EverySecondOneFailsRepository sharedRepository = new EverySecondOneFailsRepository();

    @Test
    public void testAlwaysFails() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        mock2.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:fails", (Object)"hello world", "id", (Object)1);
            Assertions.fail((String)"Should throw CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(OptimisticLockingAggregationRepository.OptimisticLockingException.class, e.getCause().getCause());
        }
        try {
            this.template2.sendBodyAndHeader("direct:fails", (Object)"hello world", "id", (Object)1);
            Assertions.fail((String)"Should throw CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(OptimisticLockingAggregationRepository.OptimisticLockingException.class, e.getCause().getCause());
        }
        mock.assertIsSatisfied();
        mock2.assertIsSatisfied();
    }

    @Test
    public void testEverySecondOneFails() throws Exception {
        int size = 200;
        ExecutorService service = Executors.newFixedThreadPool(10);
        List<Callable<Object>> tasks = this.createTasks(size);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        service.invokeAll(tasks);
        service.shutdown();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        int contextCount = mock.getReceivedCounter();
        int context2Count = mock2.getReceivedCounter();
        Assertions.assertEquals((int)25, (int)(contextCount + context2Count));
    }

    private List<Callable<Object>> createTasks(int size) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        int i = 0;
        while (i < size) {
            int id = i % 25;
            int choice = i % 2;
            int count = i++;
            tasks.add(() -> this.sendTask(choice, count, id));
        }
        return tasks;
    }

    private Object sendTask(int choice, int count, int id) {
        if (choice == 0) {
            this.template.sendBodyAndHeader("direct:everysecondone", (Object)Integer.toString(count), "id", (Object)id);
        } else {
            this.template2.sendBodyAndHeader("direct:everysecondone", (Object)Integer.toString(count), "id", (Object)id);
        }
        return null;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:fails").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)new AlwaysFailingRepository()).optimisticLocking().optimisticLockRetryPolicy(new OptimisticLockRetryPolicy().maximumRetries(5).retryDelay(0L)).completionSize(2).to("mock:result");
                this.from("direct:everysecondone").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)DistributedOptimisticLockFailingTest.this.sharedRepository).optimisticLocking().completionSize(8).to("mock:result");
            }
        };
    }

    private static final class EverySecondOneFailsRepository
    extends MemoryAggregationRepository {
        private final AtomicInteger counter = new AtomicInteger();

        private EverySecondOneFailsRepository() {
            super(true);
        }

        public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
            int count = this.counter.incrementAndGet();
            if (count % 2 == 0) {
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
            return super.add(camelContext, key, oldExchange, newExchange);
        }
    }

    private static final class AlwaysFailingRepository
    extends MemoryAggregationRepository {
        private AlwaysFailingRepository() {
        }

        public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
            throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
        }
    }
}

