/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistributedConcurrentPerCorrelationKeyTest
extends AbstractDistributedTest {
    private final MemoryAggregationRepository sharedAggregationRepository = new MemoryAggregationRepository(true);

    @Test
    public void testAggregateConcurrentPerCorrelationKey() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(50);
        List<Callable<Object>> tasks = this.createTasks();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        service.invokeAll(tasks);
        service.shutdown();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        int contextCount = mock.getReceivedCounter();
        int context2Count = mock2.getReceivedCounter();
        Assertions.assertEquals((int)25, (int)(contextCount + context2Count));
    }

    private List<Callable<Object>> createTasks() {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        int size = 200;
        int i = 0;
        while (i < size) {
            int id = i % 25;
            int choice = i % 2;
            int count = i++;
            tasks.add(() -> this.sendTask(choice, count, id));
        }
        return tasks;
    }

    private Object sendTask(int choice, int count, int id) {
        String uri = "direct:start";
        if (choice == 0) {
            this.template.sendBodyAndHeader(uri, (Object)Integer.toString(count), "id", (Object)id);
        } else {
            this.template2.sendBodyAndHeader(uri, (Object)Integer.toString(count), "id", (Object)id);
        }
        return null;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)DistributedConcurrentPerCorrelationKeyTest.this.sharedAggregationRepository).optimisticLocking().completionSize(8).to("mock:result");
            }
        };
    }
}

